<?php
session_start();
//functionality written by ashish pandey
error_reporting(0);
$conn = new mysqli('localhost', 'root', '', 'tms_db') or die("Could not connect to MySQL: " . mysqli_error($conn));
$from_date = $_POST['from_date']; 
$to_date = $_POST['to_date']; 

$query = "SELECT * FROM task_list WHERE start_date BETWEEN ? AND ?";
$stmt = $conn->prepare($query);

$stmt->bind_param("ss", $from_date, $to_date);
$stmt->execute();
$result = $stmt->get_result();

if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        $tasks = unserialize($row['task']);
        $time_taken_values = unserialize($row['time_taken']);

        $total_seconds = 0;
        foreach ($time_taken_values as $time_taken) {
            list($hours, $minutes, $seconds) = explode(':', $time_taken);
            $total_seconds += $hours * 3600 + $minutes * 60 + $seconds;
        }

        $total_hours = floor($total_seconds / 3600);
        $total_minutes = floor(($total_seconds % 3600) / 60);
        $total_seconds_remaining = $total_seconds % 60;

        $total_time_taken = sprintf('%02d:%02d:%02d', $total_hours, $total_minutes, $total_seconds_remaining);
        echo "<tr>";
        echo "<td>" . $row['id'] . "</td>";
        echo "<td>";
        foreach ($tasks as $task) {
            echo "<p><b>" . $task . "</b></p>";
        }
        echo "</td>";
        echo "<td>" . $row['start_date'] . "</td>";
        echo "<td>";
        foreach ($time_taken_values as $time_taken) {
            echo "<p><b>" . $time_taken . "</b></p>";
        }
        echo "</td>";
        echo "<td>" . $total_time_taken . "</td>";
        echo "<td>";
        echo "<button type='button' class='btn btn-default btn-sm btn-flat border-info wave-effect text-info dropdown-toggle' data-toggle='dropdown' aria-expanded='true'>Action</button>";
        echo "<div class='dropdown-menu' style=''>";
        echo "<a class='dropdown-item view_task' href='./index.php?page=view_task&id=" . $row['id'] . "' data-id='" . $row['id'] . "'>View</a>";
        echo "<div class='dropdown-divider'></div>";
        if (isset($_SESSION['login_type']) && $_SESSION['login_type'] != 3):
            echo "<a class='dropdown-item' href='./index.php?page=edit_task&id=" . $row['id'] . "'>Edit</a>";
            echo "<div class='dropdown-divider'></div>";
            echo "<a class='dropdown-item delete_project' href='javascript:void(0)' data-id='" . $row['id'] . "'>Delete</a>";
        endif;
        echo "</div>";
        echo "</td>";
        // Output other columns as needed
        echo "</tr>";
    }
} else {
    echo "<tr><td colspan='5'>No data found</td></tr>";
}

$stmt->close();
$conn->close();
?>
